appModule.controller('PreviewCtrl', ["$scope", "notices", "pages", "api", "log", "utils", "$translate", "$sce", "$timeout", "native",function ($scope, notices, pages, api, log, utils, translate, $sce, $timeout, native) {
    $scope.setInputEditorCaretPosition = function ($event) {
        utils.setInputEditorCaretPosition($($event.currentTarget));
    };

    $scope.onInputCaretPositionKeyUp = function ($event) {
        $event.stopPropagation();
        utils.onInputCaretPositionKeyUp($($event.currentTarget));
    };

    $scope.init = function () {
        var userInfo = native.getUserInfo();
        $scope.notice = notices.notice.create();
        var params = window.location.search;
        $scope.notice.id = utils.getUrlParam(params, 'id');
        $scope.notice.forceAvatar = utils.getUrlParam(params, 'forceAvatar');
        if(!$scope.notice.id){
            var localId = utils.getUrlParam(params, 'localId');
            $scope.notice = notices.getDraftByLocalId(localId);
            $scope.notice.createTime = utils.getUrlParam(params, 'createTime');
        }
        $scope.accountName = utils.getUrlParam(params, 'accountName');
        pages.addWindowCloseListener($scope.onClose);
    };

    $scope.init();

    if ($scope.notice.id) {
        api.getOneNotice($scope.notice.id, function (data) {
            utils.applyScope($scope, function () {
                var tempNotice = notices.notice.create();
                notices.notice.convertFromData(tempNotice, data);
                $scope.notice = $.extend($scope.notice, tempNotice);
                if ($scope.notice.commentEnabled) {
                    $scope.showComments = true;
                    $scope.$broadcast('getComments');
                }
            });
        }, function (msg, errorCode) {
            log.logInfo("failed to load notice " + $scope.notice.id + "'s detail:" + msg);
            var option = {
                msg: msg,
                onConfirm: function () {
                    $scope.onClose();
                },
                onCancel: null,
                isShowCancel: false
            };
            api.notifyError(option);
        });
    }else{
        if($scope.notice.ext_data && $scope.notice.ext_data.end_time){
            $scope.notice.ext_data.end_time = utils.time2str($scope.notice.ext_data.end_time/1000);
        }
    }

    $scope.plainHTML = function (html) {
        return $sce.trustAsHtml(html);
    };

    $scope.onScrollDown = function(){
        $scope.$broadcast("onScrollDown");
    };

    $scope.onClose = function () {
        $scope.$destroy();
        pages.closeWindow();
    };
}]);
